create or replace package body tbicds.PCK_REPORTS_PI is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Get population module series recordset
*/
procedure GetPopModuleSeriesRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nSiteID                in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := '
      select distinct(series)  
      from report_population_module t,
           data_intake_score ds
      where t.fx_user_id = :USER_ID  
        and t.mid = :MID 
        and (t.site_id = :SITE_ID 
               or :SITE_ID = -1) 
            
       and( t.admission_intake_id = ds.intake_id 
         or t.discharge_intake_id = ds.intake_id
         or t.followup_intake_id = ds.intake_id)
      order by series';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nMID,
          pi_nSiteID,
          pi_nSiteID;
          
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get populatuion module recordset
*/
procedure GetPopModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
   
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select t.*,
     
        tbicds.fnc_utl_decstr(t2.last_name, 
                            :KEY, 
                            t2.PATIENT_ID) as last_name,
                            
        tbicds.fnc_utl_decstr(t2.first_name, 
                            :KEY2, 
                            t2.PATIENT_ID) as first_name
                                     
         from REPORT_POPULATION_MODULE t,
              PATIENT_DEMOGRAPHICS t2
        where t.FX_USER_ID = :USERID
          and t2.patient_id = t.patient_id
         order by t.MID';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_vKey,
          pi_vKey,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get population site recordset
*/
procedure GetPopSiteIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select distinct t.site_id 
                               from report_population t 
                               where t.fx_user_id = :USER_ID 
                               ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get population module recordset
*/
procedure GetPopMIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select distinct t.mid  
                               from report_population_module t 
                               where t.fx_user_id = :USER_ID 
                               ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




/*gets population average scores*/
procedure GetPopScoreAvgRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 
'select s.site_name, m.module, 
        ds.mid, 
        t.site_id, 
        ds.series, 
        ds.description,
        round(avg(score),2) as average_score, 
        round(avg(los),2) as average_los,
        ''ADMISSION'' as score_type  
from report_population_module t,
     data_intake_score ds, 
     utl_site s, 
     intake_module m 
where t.admission_intake_id = ds.intake_id 
  and s.site_id = t.site_id 
  and m.mid = ds.mid 
  and t.fx_user_id = :UID1 
group by t.site_id, ds.mid, ds.series, ds.description, s.site_name, m.module 

union 

select  s.site_name, m.module, ds2.mid, t2.site_id, 
ds2.series, 
ds2.description,
round(avg(score),2) as average_score, 
round(avg(los),2) as average_los,
''DISCHARGE'' as score_type  
from report_population_module t2,
data_intake_score ds2,
 utl_site s, 
 intake_module m  
where t2.discharge_intake_id = ds2.intake_id
 and s.site_id = t2.site_id 
  and m.mid = ds2.mid 
and t2.fx_user_id = :UID2  
group by t2.site_id, ds2.mid, ds2.series, ds2.description, s.site_name, m.module 

union

select  s.site_name, m.module, ds3.mid, t3.site_id, 
ds3.series,
ds3.description,
round(avg(score),2) as average_score,
round(avg(los),2) as average_los, 
''FOLLOWUP'' as score_type  
from report_population_module t3,
data_intake_score ds3,
  utl_site s, 
     intake_module m 
where t3.followup_intake_id = ds3.intake_id
 and s.site_id = t3.site_id 
  and m.mid = ds3.mid 
and t3.fx_user_id = :UID3 
group by t3.site_id, ds3.mid, ds3.series, ds3.description, s.site_name, m.module 

order by  site_id, mid, series, score_type 
';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nUserID,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*gets population scores for all sites*/
procedure GetPopScoreAvgALLRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nExcludeSiteID         in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 
'select ds.mid, 
        ''All'' as site_name, 
        m.module,  
        -1 as site_id, 
        ds.series, 
        ds.description,
        round(avg(score),2) as average_score, 
        round(avg(los),2) as average_los,
        ''ADMISSION'' as score_type  
from report_population_module t,
data_intake_score ds,
     intake_module m 
where t.admission_intake_id = ds.intake_id
  and m.mid = ds.mid 
and t.fx_user_id = :UID1 
and t.site_id != :ExcludeSiteID
group by ds.mid, ds.series, ds.description, m.module 

union 

select ds2.mid, 
       ''All'' as site_name, 
       m.module,      
       -1 as site_id,    
ds2.series, 
ds2.description,
round(avg(score),2) as average_score, 
round(avg(los),2) as average_los,
''DISCHARGE'' as score_type  
from report_population_module t2,
data_intake_score ds2,
     intake_module m 
where t2.discharge_intake_id = ds2.intake_id
  and m.mid = ds2.mid 
and t2.fx_user_id = :UID2 
and t2.site_id <> :ExcludeSiteID 
group by ds2.mid, ds2.series, ds2.description, m.module 

union

select ds3.mid, 
       ''All'' as site_name, 
       m.module,
       -1 as site_id, 
ds3.series,
ds3.description,
round(avg(score),2) as average_score,
round(avg(los),2) as average_los, 
''FOLLOWUP'' as score_type  
from report_population_module t3,
data_intake_score ds3,
     intake_module m 
where t3.followup_intake_id = ds3.intake_id
  and m.mid = ds3.mid 
and t3.fx_user_id = :UID3 
and t3.site_id != :ExcludeSiteID
group by ds3.mid, ds3.series, ds3.description, m.module 

order by  mid, series, score_type 
';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nExcludeSiteID,
          pi_nUserID,
          pi_nExcludeSiteID,
          pi_nUserID,
          pi_nExcludeSiteID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*gets population scores*/
procedure GetPopScoreRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := '

select * from (         
select t.site_id, ds.*, ''ADMISSION'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
  
from report_population_module t,
data_intake_score ds,
patient_demographics p
where t.admission_intake_id = ds.intake_id 
and t.patient_id = p.patient_id 
and t.fx_user_id = :UID1

union

select t2.site_id, ds2.*, ''DISCHARGE'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
   
from report_population_module t2,
data_intake_score ds2,
patient_demographics p
where t2.discharge_intake_id = ds2.intake_id
and t2.patient_id = p.patient_id 
and t2.fx_user_id = :UID2


union

select t3.site_id, ds3.*, ''FOLLOWUP'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
   
from report_population_module t3,
data_intake_score ds3,
patient_demographics p
where t3.followup_intake_id = ds3.intake_id 
and t3.patient_id = p.patient_id 
and t3.fx_user_id = :UID3
)
order by site_id, mid, series';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using
          pi_vKey, 
          pi_vKey,
          pi_nUserID,
          
          pi_vKey, 
          pi_vKey,
          pi_nUserID,
          
          pi_vKey, 
          pi_vKey,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*loads module data to the temp table*/
procedure LoadPopModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nMID                   in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --clear any old data in the population module table
    --from this module
    delete from report_population_module t 
    where t.mid = pi_nMID
      and t.fx_user_id = pi_nUserID;
    commit;
    
    --create records for the mid
    insert into report_population_module(patient_id,
                                         fx_user_id,
                                         initial_date,
                                         end_date,
                                         mid,
                                         admission_intake_id,
                                         discharge_intake_id,
                                         followup_intake_id,
                                         los,
                                         site_id) 
    select patient_id,
           fx_user_id,
           initial_date,
           end_date,
           pi_nMID,
           null,
           null,
           null,
           --null,
           --NUMTODSINTERVAL(end_date - initial_date, 'DAY'),
           trunc(end_date - initial_date),
           site_id                   
    from report_population pp
    where pp.fx_user_id = pi_nUserID;
    
    commit;   

    --set the admission intake id
    update report_population_module ta
    set ta.admission_intake_id = PCK_REPORTS.GetAdmissionIntakeID(ta.mid,
                                                      ta.patient_id,
                                                      ta.initial_date,
                                                      ta.end_date)
         
    where ta.fx_user_id = pi_nUserID
      and ta.mid = pi_nMID;
    commit;                                                     
                      
    --set the discharge intake id
    update report_population_module td 
       set  td.discharge_intake_id = PCK_REPORTS.GetDischargeIntakeID(td.mid,
                                                          td.patient_id,
                                                          td.initial_date,
                                                          td.end_date)                                            
                                                     
                                                     
    where td.fx_user_id = pi_nUserID
    and td.mid = pi_nMID;
    commit;                           
        
    
    --set the followup intake id
    update report_population_module tf 
       set  tf.followup_intake_id = PCK_REPORTS.GetFollowupIntakeID(tf.mid,
                                                        tf.patient_id,
                                                        tf.discharge_intake_id)                                            
                                                     
                                                     
    where tf.fx_user_id = pi_nUserID
    and tf.mid = pi_nMID;
    commit;   
                               
            
    --now loop and do something to report_population
    --FOR rec IN (SELECT *
    --              FROM report_population t
    --             where t.fx_user_id = pi_nUserID) 
    --LOOP
    --
    --         null;
    --
    --
    --END LOOP;
    

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*loads a temp table with population matching criteria*/
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPATypeID             in number, --type
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_vGender                in varchar2,
      pi_nMilStatusID           in number,
      pi_vSiteIDS               in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(4000) :=
      'insert into report_population(fx_user_id,
                                     patient_id,
                                     initial_date,
                                     end_date,
                                     site_id)
       select :UserID as fx_user_id,
              t.patient_id,
              t2.initial_date,
              t2.end_date,
              t.site_id
       from patient_demographics t,
            pat_treatment_program t2,
            pat_treatment t3
       where t2.patient_id = t.patient_id
       and t2.treatment_id = t3.treatment_id 
       and ( (:GENDER = ''-1'')
             or 
             ( tbicds.fnc_utl_decstr(t.gender, 
                                     :KEY, 
                                     t.PATIENT_ID) = :GENDER2
              )
            )
       
       and ( (:SITES = ''-1'')
             or
             ( 
               instr(:MATCH_SITES, '','' || t.site_id || '','' ) > 0
              )
            )

       and t2.end_date is not null
       and (      trunc(t2.end_date) >= trunc(:DTFROM)
              and trunc(t2.end_date) <= trunc(:DTEND)
              and ( (:CLINSETT = -1)
                      or
                    (t3.treatment_type_id = :CLINSETT2)
                   )
              
               and ( (:CPA_TYPE = ''-1'')
                   or
                   ( 
                      :CPA_TYPE2 = 
                         (select cpa_type_id  
                            from cpa cp  
                           where cp.cpa_id = t2.cpa_id )
                    )
                  ) 
              
              
              
            ) 
            
        and ( (:IMPAIRMENT1 = -1)
                or
                (
                  :IMPAIRMENT2 = PCK_REPORTS.GetImpairmentRID(t.patient_id, t2.end_date)                
                )
             )

       and ( (:INJURY1 = -1)
                or
                (
                  :INJURY2 = PCK_REPORTS.GetInjuryRID(t.patient_id, t2.end_date)                
                )
             )      
             
       and ( (:DUTYSTATUS1 = -1)
                or
                (
                  :DUTYSTATUS2 = t.duty_status_id                 
                )
             )           
       ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --delete current cached records for this user
    delete 
    from report_population t 
    where t.fx_user_id = pi_nUserID;
    commit;
    
    delete from report_population_module tm
    where tm.fx_user_id = pi_nUserID;
    commit;
    
    
    --execute the SQL
    EXECUTE IMMEDIATE v_vSQL
    USING pi_nUserID,
          pi_vGender,
          pi_vKey,
          pi_vGender,
          pi_vSiteIDS,
          pi_vSiteIDS,
          pi_dtFrom,
          pi_dtTo,
          pi_nClinicalSetting,
          pi_nClinicalSetting,
          pi_nCPATypeID,
          pi_nCPATypeID,
          pi_nImpairmentID,
          pi_nImpairmentID,
          --pi_dtTo,
          pi_nInjuryID,
          pi_nInjuryID,
          --pi_dtTo,
          pi_nMilStatusID,
          pi_nMilStatusID;
         
    
    commit;

--exception
  --  when others then
    --  po_nStatusCode    := 1;
     -- po_vStatusComment := '';
      
end;


end PCK_REPORTS_PI;
/

